*openUBMC openUBMC 支持raid卡的硬盘故障记录功能的开启或者关闭详细设计说明书*

<table>
    <tr>
        <td>所属SIG组:</td>
        <td>hardware</td>
    </tr>
    <tr>
        <td>落入版本:</td>
        <td>25.12</td>
    </tr>
    <tr>
        <td>设计人员:</td>
        <td>李东辉</td>
    </tr>
    <tr>
        <td>日期:</td>
        <td>2025/11/14</td>
    </tr>
</table>


**Copyright © 2025 openUBMC Community**

您对&quot;本文档&quot;的复制，使用，修改及分发受木兰宽松许可证, 第2版协议(以下简称&quot;MulanPSL2&quot;)的约束。
为了方便用户理解，您可以通过访问<https://license.coscl.org.cn/MulanPSL2>了解MulanPSL2的概要 (但不是替代)。
MulanPSL2的完整协议内容您可以访问如下网址获取：<https://license.coscl.org.cn/MulanPSL2>。

**改版记录**

<table>
    <tr>
        <th>日期</th>
        <th>修订版本</th>
        <th>修订描述</th>
        <th>作者</th>
        <th>审核</th>
    </tr>
    <tr>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
    </tr>
</table>

**List of abbreviations**  **缩略语清单** ：

<table>
    <tr>
        <th>Abbreviations 缩略语</th>
        <th>Full spelling 英文全名</th>
        <th>Chinese explanation 中文解释</th>
    </tr>
    <tr>
        <td>I2C</td>
        <td>Inter-Integrated Circuit</td>
        <td>是一种串行通信协议，通常用于微控制器（MCU）和外设之间的短距离通信</td>
    </tr>
</table>

[TOC]

# 1.功能分析
## 1.1 功能背景
<!-- 描述该需求的来源或背景，比如：支撑XXX功能、XXX优化等；以及该需求对用户（含组件）带来什么具体价值，如果没有该需求，对用户（含组件）带来什么损失； -->
多Raid卡场景时，当使用I2C链路进行通信时，因为上层业务是并行处理，底层I2C链路是串行处理，导致过多Raid卡请求阻塞在请求队列无法及时响应</br>
因此修改上层业务为串行处理，防止队列阻塞，返回请求超时，这样可以解决因请求超时导致Raid卡带外信息没有正常更新的问题

## 1.2 功能描述
<!-- 描述该需求交付的整体功能，主要实现XXX功能，解决XXX问题，明确方案如何实现 -->
修改Raid卡带外请求方式，由并行触发改为串行触发

## 1.3 功能场景
1.反复重启OS场景
2.其他压力测试场景

## 1.4 功能列表
<!-- 描述该需求交付的功能列表，内容包括：列出功能详细描述，标题、描述。 -->
| 功能编号 | 功能标题 | 功能描述 |
| ------- | ------- | -------- |
| 1 | 优化多Raid时I2C链路性能阻塞问题 | 修改带外并行处理逻辑为串行处理，防止队列请求阻塞超时 |

# 2.功能设计
## 2.1 总体方案分析
<!-- 描述该方案的总体设计（注：相关输出方案可同步刷新到各组件仓） -->
storage组件管理raid卡相关对象主要包括：controller、array、volume、battery、drive，每个对象都会调用特定的插件请求从raid卡中获取数据，实现带外管理。</br>当前插件调用采用创建task的并行方式完成的，在多raid卡场景下导致过多的task同时运行，插件请求阻塞在插件队列中得不到调用，产生超时，导致带外管理异常。

### 2.1.1 方案详细设计
#### 2.1.1.1 方案概述
<!-- 描述该方案的整体实现，内容包括：涉及的关键点，实现策略等 -->
并行插件分析如下：
|对象|并行task|插件请求|循环周期|
|---|---|---|---|
|controller|task1|sml.get_ctrl_info</br>sml.get_ctrl_sas_addr</br>sml.get_ctrl_boot_device</br>sml.get_ctrl_faultcode|20s|
|controller|task2|sml.get_ctrl_pd_list|10s|
|controller|task3|sml.get_ctrl_array_list|60s|
|array|task4|sml.get_array_info|30s|
|controller|task4|sml.get_ctrl_ld_list|60s|
|volume|task5|sml.get_ld_info|30s|
|controller|task6|sml.get_ctrl_sas_phy_err|60s|
|battery|task7|sml.get_battery_info|60s|
|drive|task8|sml.get_pd_info|10s|
|drive|task9|sml.get_pd_smart_info|300s|
|drive|task10|sml.pd_log_get_drive_log</br>sml.pd_get_smart_info_str</br>sml.pd_log_write_subhealthy_info|24h|

将上述并行task改为串行task，依次调用插件请求，防止过多请求阻塞在插件队列中导致超时。
|对象|并行task|插件请求|循环周期|
|---|---|---|---|
|controller|task1|sml.get_ctrl_info</br>sml.get_ctrl_sas_addr</br>sml.get_ctrl_boot_device</br>sml.get_ctrl_faultcode</br>sml.get_ctrl_pd_list</br>sml.get_ctrl_array_list</br>sml.get_ctrl_ld_list</br>sml.get_ctrl_sas_phy_err|xs|
|array|task2|sml.get_array_info|30s|
|volume|task3|sml.get_ld_info|30s|
|battery|task4|sml.get_battery_info|60s|
|drive|task5|sml.get_pd_info</br>sml.get_pd_smart_info|xs|
|drive|task6|sml.pd_log_get_drive_log</br>sml.pd_get_smart_info_str</br>sml.pd_log_write_subhealthy_info|24h|

#### 2.1.1.2 开发视图
<!-- 开发视图面向系统开发及软件管理，描述系统代码结构，构建结构的视图，主要解决系统技术实现和开发的问题，它依托逻辑视图，描述代码、构建结构 -->
不涉及

#### 2.1.1.3 运行视图
<!-- 运行视图面向系统运行，描述系统启动过程、运行期交互的视图，主要解决系统运行期交互，描述各可执行交付件在运行期的交互关系 -->
```mermaid
sequenceDiagram
    participant controller
    participant array
    participant volume
    participant battery
    participant drive
    controller->>controller:sml.get_ctrl_info
    controller->>controller:sml.get_ctrl_sas_addr
    controller->>controller:sml.get_ctrl_boot_device
    controller->>controller:sml.get_ctrl_faultcode
    controller->>controller:sml.get_ctrl_pd_list
    controller->>drive:定位任务
    drive->>drive:sml.get_pd_info
    drive->>drive:sml.get_pd_smart_info(sas盘)
    drive->>drive:sml.pd_log_get_drive_log
    drive->>drive:sml.pd_get_smart_info_str
    drive->>drive:sml.pd_log_write_subhealthy_info
    controller->>controller:sml.get_ctrl_array_list
    controller->>array:创建array对象
    array->>array:sml.get_array_info
    controller->>controller:sml.get_ctrl_ld_list
    controller->>volume:创建volume对象
    volume->>volume:sml.get_ld_info
    controller->>controller:sml.get_ctrl_sas_phy_err
    controller->>battery:创建battery对象
    battery->>battery:sml.get_battery_info
```

### 2.1.2 内部依赖分析
<!-- 是否涉及与其他组件接口依赖，如果涉及需要确认当前是否已完成，是否匹配当前需求开发诉求 -->
不涉及
### 2.1.3 外部依赖分析
<!-- 是否涉及与平台SDK的依赖关系 -->
需要依赖多个支持I2C链路的raid卡

### 2.1.4 北向接口分析
<!-- 需要分析当前功能是否有以下接口影响，如果有影响，则需要具体的补充影响点。其中注意点如下：
（1）如果有新增IPMI接口，请排查代码中IPMI命令注册的过滤字段，是否完全和IPMI命令的定义一致？
（2）新增一个接口时，需要咨询SIG组是否还有其他的接口受影响 -->
| 特性 | SNMP | CLI | WEB | KVM_VMM | IPMI(RMCP/RMCP+) | HMM | Redfish |
| ---- | ---- | ---- | --- | ------ | ---------------- | --- | ------- |
| 优化多Raid时I2C链路性能阻塞 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |

### 2.1.5 兼容性分析
<!-- 当前的功能对现有在网的功能是否有影响，具体的影响点进行分析之后输出影响分析表格 -->
仅该仓代码修改，不涉及配套兼容性问题

### 2.1.6 定制化接口分析
不涉及
### 2.1.7 导入导出分析
<!-- 如果支持导入导出的配置，则需要分析导入导出的schema。 -->
不涉及
### 2.1.8 传感器分析
<!-- 如果需要新增传感器，则需要提前登记和评审新增的传感器要素。新增传感器评审需要上SIG-Interface进行评审 -->
不涉及
### 2.1.9 精准告警事件分析
<!-- 如果需要新增事件，则需要提前登记和评审新增的时间要素 -->
不涉及
### 2.1.10 系统锁定分析
<!-- 对外的接口或者命令是否支持系统锁定 -->
不涉及
### 2.1.11 用例场景分析
<!-- 以表格的形式输出该需求涉及的用例场景 -->
| 用例编号 | 用例描述 | 前置条件 |执行步骤 | 预期结果 |
| --- | --- | --- | --- | --- |
| 1 | 验证单raid卡带外管理是否正常 | 不同厂商的raid卡 | 1.升级后观测web带外管理 | 带外管理正常 |
| 2 | 验证单raid卡DC场景 | 不同厂商的raid卡 | 1.触发DC | DC前后带外管理正常 |
| 3 | 验证单raid卡AC场景 | 不同厂商的raid卡 | 1.触发AC | AC前后带外管理正常 |
| 4 | 验证单raid卡带外创建逻辑盘 | 不同厂商的raid卡 | 1.在带外管理页面创建逻辑盘 | 逻辑盘创建成功 |
| 5 | 验证4raid卡带外管理是否正常 | 3raid走iic链路，1raid走mctp链路 | 1.升级观测带外管理从异常到正常的时间 | 对比重构前版本，时间有下降 |
| 6 | 验证4raid卡DC场景 | 3raid走iic链路，1raid走mctp链路 | 1.触发DC | DC前后带外管理正常 |
| 7 | 验证4raid卡AC场景 | 3raid走iic链路，1raid走mctp链路 | 1.触发AC | AC前后带外管理正常 |
| 8 | 验证4raid卡带外创建逻辑盘 | 3raid走iic链路，1raid走mctp链路 | 1.在带外管理页面创建逻辑盘 | 逻辑盘创建成功 |
| 9 | 验证4raid卡反复DC场景 | 3raid走iic链路，1raid走mctp链路 | 1.间隔xs触发DC | 带外管理正常 |
| 10 | 验证单raid卡DC、AC场景误告警 | 不同厂商的raid卡 | 1.触发DC、AC场景 | 无误告警产生 |
| 11 | 验证4raid卡DC、AC场景误告警 | 3raid走iic链路，1raid走mctp链路 | 1.触发DC、AC场景 | 无误告警产生 |

## 2.2 非功能质量属性设计
### 2.2.1 扩展性分析
<!-- 考虑后续新增类似功能可以很好地扩展 -->
不涉及
### 2.2.2 重用性分析
<!-- 是否为通用处理方式、接口，如果是得考虑重用性 -->
不涉及

### 2.2.3 可测试性分析
<!-- 此需求如何验证，是否可直接验证，or通过XXX功能覆盖验证，or需要单独怎加测试接口验证 -->
1.带外管理可以通过web页面进行观测
2.时间可以通过日志进行观测

### 2.2.4 资料分析

<!-- 是否涉及资料修改 -->
不涉及

### 2.2.5 资源使用分析
<!-- 新增线程、内存分配、模型属性名长度是否合理，CPU占用率是否会激增，Flash中新增文件是否合理（频繁读写Flash会大幅缩短emmc寿命）；是否涉及消息队列，如果涉及请检查是否存在某些场景下消息队列会满导致消息丢失，例如大量消息发送到队列且处理消息需要耗费较长时间的场景。 -->
不涉及
### 2.2.6 可靠性分析
<!-- 是否涉及可靠性设计，例如：新增模块是否有容错设计，是否有异常处理设计，是否有重试设计等 -->
|编号|场景|问题描述|可靠性影响|建议解决方案/需求|备注|
| --- | --- | --- | --- | --- | --- |
| 1 | DC场景 | 多次DC的时间间隔太短，带外管理还没有正常又被触发DC | 影响带外管理| 对其验证规格| - |
| 2 | raid卡注册场景 | 当前使用skynet的register_protocol注册服务，要求ID唯一，若i2c设备数量增加，会导致ID冲突| 影响带外管理| 验证4raid规格| - |
| 3 | 定位场景| 定位依赖获取raid卡pd_list，改变插件发送方式后，可能对定位场景有时序上的影响| 影响定位场景| 验证4raid规格是否存在该问题 | - |
| 4 | 告警影响 | 优化后raid卡更新数据相比之前有延迟 | 影响告警时机 | 验证排查影响 | - |
| 5 | drive对象任务改为状态控制 | 可能状态变化后，task内部回掉函数还在执行 | 设置无效之后又被设为有效值 | 状态变化后，调用设置默认值函数 | - |
| 6 | 串行场景，任务执行失败影响其他任务 | task中回调函数失败后会影响当前周期的其他对象的回调函数执行，跟原有流程不一致 | 影响其他任务执行 | 使用pcall控制，不影响其他对象的执行 | - |

### 2.2.7 安全性分析
| 安全合规项 | 是否涉及 | 现有的防护措施 |
| --- | --- | --- |
| 访问控制（通道、文件权限、用户权限、查询权限、配置权限、接口权限） | 不涉及 |  |
| 敏感数据 | 不涉及 |  |
| 日志（操作日志、维护日志、安全日志、运行日志） | 不涉及 |  |
| 文档 | 不涉及 |  |
| 加密及算法 | 不涉及 |                      |
| 新增关键资源（密钥、证书、关键配置）备份、恢复 | 不涉及 |  |
| 新增对外接口入参校验 | 不涉及 |  |
| 新增开源及三方软件引入 | 不涉及 |  |
# 3.功能实现
<!-- 通过表格、流程图、简明文字描述提供，力求容易看懂、容易实现，详细描述细节。 -->
## 3.1 优化多Raid时I2C链路性能阻塞
### 3.1.1 功能实现设计
将原有各对象的并行收集改为串行收集，以减少I2C链路性能阻塞的风险。

### 3.1.2 功能详细设计
1.在controller_object中起一个task，串行收集当前controller相关的信息</br>
2.在battery_collection中起一个task，串行收集所有battery相关的信息</br>
3.在drive_collection中起一个task，串行收集所有drive相关的信息</br>
4.在array_collection中起一个task，串行收集所有array相关的信息</br>
5.在volume_collection中起一个task，串行收集所有volume相关的信息</br>

### 3.1.3 开发者测试
<!--
增加模块接口：以活动图/流程图等形式明确模块内处理流程，针对模块处理流程中的分支进行覆盖
修改模块接口处理流程：覆盖修改影响流程分支
-->
#### 3.1.3.1 单元测试
<!-- UT，主要是功能单元测试，测试对象是功能单元接口。UT测试设计要从黑盒（功能）角度设计，从输入(I)、处理（B）、预期输出（O）的角度进行用例分析设计，测试覆盖率仅作为反馈，用于分析哪些功能场景没有覆盖到，从而指导测试设计优化并补充测试用例 -->

| 组件名  | 用例类型 | 测试用例描述                                 | 用例名称                                  | 预置条件   | 操作步骤                                                     | 预期结果  |
| ------- | -------- | -------------------------------------------- | ----------------------------------------- | ---------- | ------------------------------------------------------------ | --------- |
| Storage | UT       | 多raid卡获取带外pd数据                 | test_multi_raid_get_pd_info | 1.打桩4raid；2.打桩pd信息 | 调用get_pd_info接口 | 返回数据和打桩数据一致 |
| Storage | UT       | 多raid卡获取带外controller数据                 | test_multi_raid_get_ctrl_info | 1.打桩4raid；2.打桩controller信息 | 调用get_ctrl_info接口 | 返回数据和打桩数据一致 |
| Storage | UT       | 多raid卡获取带外battery数据                 | test_multi_raid_get_outband_data | 1.打桩4raid；2.打桩battery信息 | 调用get_pd_info接口 | 返回数据和打桩数据一致 |
| Storage | UT       | 多raid卡获取带外volume数据                 | test_multi_raid_get_outband_data | 1.打桩4raid；2.打桩volume信息 | 调用get_volume_info接口 | 返回数据和打桩数据一致 |
| Storage | UT       | 多raid卡获取带外array数据                 | test_multi_raid_get_array_info | 1.打桩4raid；2.打桩array信息 | 调用get_array_info接口 | 返回数据和打桩数据一致 |


#### 3.1.3.2 集成测试
<!-- IT，主要是组件/模块内的集成测试，测试对象是模块/组件接口。IT测试设计将模块/组件当作黑盒测试，IT测试用例中禁止对组件/模块内部代码打桩，如果确实有少量场景难以构造，可以考虑在测试框架中统一打桩并提供接口供测试用例调用构造场景。
说明：API测试属于IT，其测试对象是微服务接口。
PCST，是指PC上的服务集成测试，测试对象是功能需求。PCST测试设计，要覆盖正常功能、异常功能和交叉功能，采用灰盒 -->
不涉及